//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MetaInfoAssetBuilderBase.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/DynamicItemCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/DynamicPropertyItemInfoCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

namespace Candera { namespace Internal {

bool MetaInfoAssetBuilderBase::Read(CffLoaderContext& context)
{
    bool isSuccess = true;
    const Int32 propertyCount = CFFReader::GetDynamicItemDynamicPropertiesCount(context.handle);
    for (Int32 propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
        const AssetDataHandle& dynPropItemInfoHandle = CFFReader::GetDynamicItemDynamicPropertiesElementAt(context.handle, CFFReader::CFF_DYNAMIC_PROPERTY_ITEM_INFO_SIZE, propertyIndex);
        if (!dynPropItemInfoHandle.IsValid()) {
            FEATSTD_LOG_ERROR("Asset error, missing handle for meta info properties.");
            return false;
        }
        const Char* propName = AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetDynamicPropertyItemInfoName(dynPropItemInfoHandle));
        const Char* propValue = CFFReader::GetDynamicPropertyItemInfoValue(dynPropItemInfoHandle);

        if (!SetProperty(propName, propValue, context.reloadList)) {
            FEATSTD_LOG_INFO("Null %s PropertyMetaInfo %s object.",
                             propName,
                             AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetCanderaObjectCanderaName(context.handle)));
            isSuccess = false;
        }
    }
    return isSuccess;
}
}}
