//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LayouterAssetBuilder_H)
#define CANDERA_LayouterAssetBuilder_H

#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    class Layouter;
    namespace Internal {
        
        AssetLoaderTypeInfo(Candera::Layouter, CffLoaderType, Candera::CanderaObject);

        template <>
        class AssetBuilder<Layouter*>: public GenericAssetBuilderBase<Layouter*> {
        public:
            static Layouter* CreateAndBuildFirstPass(LoaderContext& context);
            static bool BuildSecondPass(Layouter* layouter, LoaderContext& context);
        private:
            enum LayouterType {
                NoLayouter, ///< No Layouter.
                BaseLine,   ///< Base line.
                Grid,       ///< Grid.
                Overlay,    ///< Overlay.
                Stack,      ///< Stack.
                DockPanel   ///< Dock panel.
            };
        };

        typedef AssetBuilder<Candera::Layouter*> LayouterAssetBuilder;
    }

}


#endif  // CANDERA_AssetReader2D_H
