//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LanguagePackAssetBuilder_H)
    #define CANDERA_LanguagePackAssetBuilder_H

#include <Candera/System/GlobalizationBase/LanguagePack.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    namespace Internal {

        /// Culture
        AssetLoaderTypeInfo(Globalization::Culture, DirectLoaderType, void);

        template<>
        class AssetBuilderBase<Globalization::Culture::SharedPointer> : public GenericAssetBuilderBase<Globalization::Culture::SharedPointer> {
            public:
                static Globalization::Culture::SharedPointer Create(LoaderContext& context);
                static void Dispose(Globalization::Culture::SharedPointer culture);
        };
    }
}

#endif  // CANDERA_LanguagePackAssetBuilder_H
