//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GDUASSETBUILDER_H)
#define CANDERA_GDUASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    class GraphicDeviceUnit;

    namespace Internal {

        AssetLoaderTypeInfo(Candera::GraphicDeviceUnit, CffLoaderType, void);

        template<>
        class AssetReaderBase<GraphicDeviceUnit>: public GenericAssetReaderBase<Candera::GraphicDeviceUnit> {
        public:
            static bool ReadSecondPass(GraphicDeviceUnit& gdu, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<GraphicDeviceUnit*>: public GenericAssetBuilderBase<GraphicDeviceUnit*> {
        public:
            static GraphicDeviceUnit* Create(LoaderContext& context);
            static void Dispose(GraphicDeviceUnit* gdu);
        };
    }
}

#endif  // CANDERA_GDUASSETBUILDER_H
