//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CanderaObjectAssetReader.h"
#include <Candera/EngineBase/Common/CanderaObject.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/CanderaObjectCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

namespace Candera {
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

    using namespace Diagnostics;

    namespace Internal {

        bool AssetReaderBase<CanderaObject>::ReadFirstPass(CanderaObject& canderaObject, LoaderContext& context)
        {
            context.id = AssetIdFunctions::GetAssetId(CFFReader::GetCanderaObjectCanderaId(context.handle));
            if (!context.id.IsValid()) {
                FEATSTD_LOG_DEBUG("GetAssetId is not valid");
            }
            canderaObject.SetName(AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetCanderaObjectCanderaName(context.handle)));
            canderaObject.SetId((context.id.m_nodeId == 0) ? AssetIdFunctions::GetLibraryId(context.id) : AssetIdFunctions::GetNodeId(context.id));
            
            return true;
        }
    }
}
