//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CAMERAGROUPASSETBUILDER_H)
#define CANDERA_CAMERAGROUPASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    class CameraGroup; 

    namespace Internal {

        AssetLoaderTypeInfo(Candera::CameraGroup, CffLoaderType, CanderaObject);

        template<>
        class AssetReaderBase<CameraGroup>: public GenericAssetReaderBase<CameraGroup> {
        public:
            static bool ReadFirstPass(CameraGroup& cameraGroup, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<CameraGroup*>: public GenericAssetBuilderBase<CameraGroup*> {
        public:
            static CameraGroup* Create(LoaderContext& context);
            static void Dispose(CameraGroup* cameraGroup);
        };
    }
}

#endif  // CANDERA_CAMERAGROUPASSETBUILDER_H
