//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BINARYTHEMEASSETBUILDER_H)
#define CANDERA_BINARYTHEMEASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    namespace Internal {
        class BinaryTheme;
        AssetLoaderTypeInfo(BinaryTheme, CffLoaderType, void);

        template<>
        class AssetReaderBase<BinaryTheme>: public GenericAssetReaderBase<BinaryTheme> {
        public:
            static bool ReadFirstPass(BinaryTheme& theme, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<BinaryTheme*>: public GenericAssetBuilderBase<BinaryTheme*> {
        public:
            static BinaryTheme* Create(LoaderContext& context);
            static void Dispose(BinaryTheme* theme);
        };
    }
}

#endif  // CANDERA_BINARYTHEMEASSETBUILDER_H
