//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BinaryThemeAssetBuilder.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/Theme.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/ThemeCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/ThemeEntryCollectionCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/ThemeEntryCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

namespace Candera {
    using namespace Diagnostics;
    namespace Internal {
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        bool AssetReaderBase<BinaryTheme>::ReadFirstPass(BinaryTheme& theme, LoaderContext& context)
        {
            context.id = AssetIdFunctions::GetAssetId(CFFReader::GetCanderaObjectCanderaId(context.handle));
            if (!context.id.IsValid()) {
                FEATSTD_LOG_DEBUG("GetAssetId is not valid");
            }
            Int32 themeEntryCollectionCount = CFFReader::GetThemeChildrenCount(context.handle);
            for (Int32 themeEntryCollectionIndex = 0; themeEntryCollectionIndex < themeEntryCollectionCount; ++themeEntryCollectionIndex) {
                const AssetDataHandle& themeEntryCollectionHandle = CFFReader::GetThemeChildrenElementAt(context.handle, themeEntryCollectionIndex);
                if (!themeEntryCollectionHandle.IsValid()) {
                    FEATSTD_LOG_ERROR("Failed to read theme entry collection of Theme " AssetIdLogStr, AssetIdLogArgs(context.id));
                    return false;
                }

                BinaryTheme::AssetIdEntryCollection* entryCollection = theme.GetAssetIdEntryCollection(AssetIdFunctions::GetAssetIdNodeIdentifier(CFFReader::GetThemeEntryCollectionCanderaId(themeEntryCollectionHandle)));
                if (entryCollection != 0) {
                    Int32 themeEntryCount = CFFReader::GetThemeEntryCollectionChildrenCount(themeEntryCollectionHandle);
                    for (Int32 themeEntryIndex = 0; themeEntryIndex < themeEntryCount; ++themeEntryIndex) {
                        const AssetDataHandle& themeEntryHandle = CFFReader::GetThemeEntryCollectionChildrenElementAt(themeEntryCollectionHandle, themeEntryIndex);
                        if (!themeEntryHandle.IsValid()) {
                            FEATSTD_LOG_ERROR("Failed to read theme entry of Theme " AssetIdLogStr, AssetIdLogArgs(context.id));
                            return false;
                        }

                        Candera::Internal::AssetId result = AssetIdFunctions::GetAssetId(CFFReader::GetThemeEntryEntryItem(themeEntryHandle));
                        if (!result.IsValid()) {
                            FEATSTD_LOG_DEBUG("Theme entry not found!");
                        }
                        if (!entryCollection->Insert(
                            AssetIdFunctions::GetAssetIdNodeIdentifier(CFFReader::GetCanderaObjectCanderaId(themeEntryHandle)),
                            result)) {
                            FEATSTD_LOG_ERROR("Failed to add theme entry to Theme " AssetIdLogStr, AssetIdLogArgs(context.id));
                        }
                    }
                }
                else {
                    FEATSTD_LOG_ERROR("Failed to create theme entry collection for Theme " AssetIdLogStr, AssetIdLogArgs(context.id));
                }
            }

            return true;
        }

        BinaryTheme* AssetBuilderBase<BinaryTheme*>::Create(LoaderContext& /*context*/)
        {
            return ASSETLOADER_TRANSIENT_NEW(BinaryTheme);
        }

        void AssetBuilderBase<BinaryTheme*>::Dispose(BinaryTheme* theme)
        {
            ASSETLOADER_DELETE(theme);
        }
    }
}
