//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AnimationPlayerAssetBuilder.h"
#include <Candera/EngineBase/Animation/AnimationController.h>
#include <Candera/EngineBase/Animation/AnimationBlendedProperty.h>
#include <Candera/EngineBase/Animation/AnimationKeyframeSequence.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/AnimationCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/AnimationBlendedPropertyListAssetReader.h>

namespace Candera {

    using namespace MemoryManagement;

    namespace Internal {

        class AnimationAnimationBlendedPropertyListAssetReader: public AnimationBlendedPropertyListAssetReader {
        public:
            AnimationAnimationBlendedPropertyListAssetReader(AssetId animationId, Animation::AnimationPlayer& animation): AnimationBlendedPropertyListAssetReader(animationId, Animation::AnimationPlayer::SharedPointer(&animation)) {}
        private:
            virtual Int32 GetAnimationPropertyCount(CffLoaderContext& /*context*/)
            {
                return 0;
                //return CFFReader::GetAnimationAnimatedPropertiesCount(context.handle);
            }

            virtual AssetDataHandle GetAnimationProperty(CffLoaderContext& /*context*/, Int32 /*index*/)
            {
                return AssetDataHandle();
                //return CFFReader::GetAnimationAnimatedPropertiesElementAt(context.handle, index);
            }

            virtual bool AddAnimationBlendedProperty(const MemoryManagement::SharedPointer<Animation::AnimationBlendedProperty>& property)
            {
                if ((m_animation != 0) && (m_animation->GetController() != 0)) {
                    return m_animation->GetController()->AddProperty(property);
                }

                return false;
            }
        };

        bool AssetReaderBase<Animation::AnimationPlayer>::ReadFirstPass(Animation::AnimationPlayer& animationPlayer, LoaderContext& context)
        {
            animationPlayer.SetController(Animation::AnimationController::Create());
            animationPlayer.SetRepeatMode(static_cast<Animation::AnimationPlayer::RepeatMode>(CFFReader::GetAnimationBaseRepeatMode(context.handle)));
            animationPlayer.SetSequenceStartTimeMs(static_cast<Animation::SequenceTimeType>(0)); //could be retrieved from the asset
            animationPlayer.SetSequenceDurationMs(static_cast<Animation::SequenceTimeType>(CFFReader::GetAnimationDuration(context.handle)));
            animationPlayer.SetDirection(static_cast<Animation::AnimationPlayer::PlayDirection>(CFFReader::GetAnimationPlayDirection(context.handle)));
            return AnimationAnimationBlendedPropertyListAssetReader(context.id, animationPlayer).Read(context);
        }

        SharedPointer<Animation::AnimationPlayer> AssetBuilderBase<SharedPointer<Animation::AnimationPlayer> >::Create(LoaderContext& /*context*/)
        {
            return Animation::AnimationPlayer::Create();
        }
    }
}
