//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ANIMATIONGROUPASSETBUILDER_H)
#define CANDERA_ANIMATIONGROUPASSETBUILDER_H

#include <Candera/EngineBase/Animation/AnimationGroupPlayer.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/AnimationPlayerBaseAssetReader.h>

namespace Candera {
    class DefaultAssetProvider;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Animation::AnimationGroupPlayer, CffLoaderType, Animation::AnimationPlayerBase);

        template<>
        class AssetReaderBase<Animation::AnimationGroupPlayer>: public GenericAssetReaderBase<Animation::AnimationGroupPlayer> {
        public:
            static bool ReadFirstPass(Animation::AnimationGroupPlayer& animationGroupPlayer, LoaderContext& context);
        private:
            static MemoryManagement::SharedPointer<Animation::AnimationPlayerBase> GetAnimationNodeBase(DefaultAssetProvider& assetProvider, const AssetDataHandle& handle);
            static MemoryManagement::SharedPointer<Animation::AnimationPlayerBase> GetAnimationNode(DefaultAssetProvider& assetProvider, const AssetDataHandle& handle);
            static MemoryManagement::SharedPointer<Animation::AnimationPlayerBase> GetCompositeAnimationNode(DefaultAssetProvider& assetProvider, const AssetDataHandle& handle);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Animation::AnimationGroupPlayer> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Animation::AnimationGroupPlayer> > {
        public:
            static MemoryManagement::SharedPointer<Animation::AnimationGroupPlayer> Create(LoaderContext& context);
        };
    }
}

#endif  // CANDERA_ANIMATIONGROUPASSETBUILDER_H
