//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ARRAYDATATYPEBASE_H)
#define CANDERA_ARRAYDATATYPEBASE_H

#include <Candera/System/MetaInfo/DataType.h>

namespace Candera {
    namespace MetaInfo {
        namespace Internal {
            class ArrayDataTypeConverterToString {
            protected:
                bool ConvertToString(Char *buf, UInt size, Int valCount);
                virtual bool ConvertItemToString(Char *buf, UInt size, Int valIndex) = 0;
            };

            class ArrayDataTypeConverterFromString {
            public:
                bool ConvertFromString(const Char *buf);

            protected:
                virtual void Reserve(Int count) = 0;
                virtual bool ConvertItemFromString(const Char* buf) = 0;
            };
        }
    }
}
#endif // CANDERA_ARRAYDATATYPEBASE_H
