//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ArrayDataTypeBase.h"
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderMemoryPool.h>
#include <Candera/System/Mathematics/Matrix4.h>
#include <Candera/System/Mathematics/Vector3.h>
#include <FeatStd/Util/NumericUtil.h>

namespace Candera {
    namespace MetaInfo {
        namespace Internal {

            static const UInt c_maxBufferSize = 256;
            static const UInt c_maxCountBufferSize = 10;

#define UpdateBuffer(buf, size, offset) \
    buf += offset; \
    size -= offset; \
    if (size <= 0) { \
        return false; \
    }

            bool ArrayDataTypeConverterToString::ConvertToString(Char *buf, UInt size, Int valCount)
            {
                Int offset = 0;
                bool result = true;
                Int newSize = static_cast<Int>(size);

                buf[0] = '[';
                UpdateBuffer(buf, newSize, 1);

                static_cast<void>(SerializationPlatform::FromBinary(buf, size, valCount, &offset));
                UpdateBuffer(buf, newSize, offset);

                buf[0] = ']';
                UpdateBuffer(buf, newSize, 1);
                buf[0] = '{';
                UpdateBuffer(buf, newSize, 1);

                Char countStr[c_maxCountBufferSize];

                for (Int entry = 0; entry < valCount; ++entry) {
                    buf[0] = '(';
                    UpdateBuffer(buf, newSize, 1);

                    result = ConvertItemToString(buf, newSize, entry) && result;
                    Int length = FeatStd::Internal::NumericConversion<Int>(StringPlatform::Length(buf));
                    Int count = 0;
                    static_cast<void>(SerializationPlatform::FromBinary(countStr, c_maxCountBufferSize, length, &count));
                    UpdateBuffer(buf, newSize, (length + count + 1));

                    Char* temp = buf - length;
                    for (Int chIndex = length; chIndex >= 0; --chIndex) {
                        temp[chIndex] = temp[chIndex - (count + 1)];
                    }

                    temp -= (count + 1);
                    StringPlatform::Copy(temp, countStr);
                    temp[count] = ')';
                }

                buf[0] = '}';

                return result;
            }
                        
            bool ArrayDataTypeConverterFromString::ConvertFromString(const Char *buf)
            {
                //buf = [3]{(5)55555(6)666666(7)7777777}
                bool result = true;
                Char localBuffer[c_maxBufferSize];
                Int entryCount = 0;
                Int offset = 0;
                buf++; //buf = 3]{(5)55555(6)666666(7)7777777}
                static_cast<void>(SerializationPlatform::ToBinary(buf, entryCount, &offset)); //entryCount = 3
                Reserve(entryCount);
                buf += offset + 2; //buf = (5)55555(6)666666(7)7777777}
                for (Int entry = 0; entry < entryCount; ++entry) {
                    UInt count = 0;
                    buf++; 
                    //entry0: buf = 5)55555(6)666666(7)7777777}
                    //entry1: buf = 6)666666(7)7777777}
                    //entry2: buf = 7)7777777}
                    static_cast<void>(SerializationPlatform::ToBinary(buf, count, &offset)); //count = 9
                    Char* tempBuffer = (count >= c_maxBufferSize) ? ASSETLOADER_TRANSIENT_NEW_ARRAY(Char, count + 1U) : localBuffer;
                    buf += offset + 1; 
                    //entry0: buf = 55555(6)666666(7)7777777}
                    //entry1: buf = 666666(7)7777777}
                    //entry2: buf = 7777777}
                    StringPlatform::CopyPartial(tempBuffer, buf, count); 
                    //entry0: tempBuffer = 55555
                    //entry1: tempBuffer = 666666
                    //entry2: tempBuffer = 7777777
                    FEATSTD_LINT_NEXT_EXPRESSION(661, "Violates MISRA C++ 2008 Required Rule 5-0-16: array has size count+1 or larger")
                    tempBuffer[count] = '\0';
                    buf += count; 
                    //entry0: buf = (6)666666(7)7777777}
                    //entry1: buf = (7)7777777}
                    //entry2: buf = }
                    result = ConvertItemFromString(tempBuffer) && result;
                    if (count >= c_maxBufferSize) {
                        ASSETLOADER_DELETE_ARRAY(tempBuffer);
                    }
                }

                return result;
            }
        }
    }
}
