//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AnimationPropertySetterFactoryCommon.h"
#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#if defined(CANDERA_LAYOUT_ENABLED)
#   include <Candera/EngineBase/Animation/LayoutMarginsPropertySetter.h>
#endif // defined(CANDERA_LAYOUT_ENABLED)
#include <CanderaAssetLoader/AssetLoaderBase/AssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>
#include <CanderaWidget/WidgetBase/WidgetBase.h>
#include <Candera/EngineBase/Animation/AbstractNodePropertySetter.h>
#include <Candera/EngineBase/Common/AbstractNodePointer.h>

namespace Candera {
        namespace Internal {

            using namespace Animation;

            AssetProvider* AnimationPropertySetterFactoryCommon::m_assetProvider = 0;

            const Int32 c_LayoutMargins = 1000;
            const Int32 c_LayoutMarginsLeft = 1001;
            const Int32 c_LayoutMarginsTop = 1002;
            const Int32 c_LayoutMarginsRight = 1003;
            const Int32 c_LayoutMarginsBottom = 1004;

            static const PropertySetterAssociation propertySettersMapper[] = {
                {apsCommonNodeLayoutMargin, 4, apcInvalid, c_LayoutMargins},
                {apsCommonNodeLayoutMargin, 1, apcLeft, c_LayoutMarginsLeft},
                {apsCommonNodeLayoutMargin, 1, apcTop, c_LayoutMarginsTop},
                {apsCommonNodeLayoutMargin, 1, apcWidth, c_LayoutMarginsRight},
                {apsCommonNodeLayoutMargin, 1, apcHeight, c_LayoutMarginsBottom}
            };

            const Int32 numMapperEntries = sizeof(propertySettersMapper) / sizeof(PropertySetterAssociation);

            template<typename BaseTypeSPtr, typename DerivedType>
            BaseTypeSPtr CreateBasePropertySetter()
            {
                return DerivedType::Create();
            }

            struct AbstractNodePropertySetterInfo {
                Int32 setterId;
                AbstractNodePropertySetter::SharedPointer(*createFctPtr)();
            };

#if defined(CANDERA_LAYOUT_ENABLED)
            static const AbstractNodePropertySetterInfo abstractNodePropertySetters[] = {
                { c_LayoutMargins, &CreateBasePropertySetter<AbstractNodePropertySetter::SharedPointer, LayoutMarginsPropertySetter> },
                {c_LayoutMarginsLeft, &CreateBasePropertySetter<AbstractNodePropertySetter::SharedPointer, LayoutMarginsLeftPropertySetter>},
                {c_LayoutMarginsTop, &CreateBasePropertySetter<AbstractNodePropertySetter::SharedPointer, LayoutMarginsTopPropertySetter>},
                {c_LayoutMarginsRight, &CreateBasePropertySetter<AbstractNodePropertySetter::SharedPointer, LayoutMarginsRightPropertySetter>},
                {c_LayoutMarginsBottom, &CreateBasePropertySetter<AbstractNodePropertySetter::SharedPointer, LayoutMarginsBottomPropertySetter>}
            };

            const Int32 npsSize = sizeof(abstractNodePropertySetters) / sizeof(AbstractNodePropertySetterInfo);
#else
            static const AbstractNodePropertySetterInfo abstractNodePropertySetters[] = {
                {0, 0}
            };

            const Int32 npsSize = 0;
#endif // defined(CANDERA_LAYOUT_ENABLED)

            
            static void SetupAbstractNodePropertySetter(Animation::AnimationPropertySetter::SharedPointer& propertySetter, AbstractNodePointer& node, AbstractNodePropertySetter::SharedPointer(*createFctPtr)())
            {
                AbstractNodePropertySetter::SharedPointer nodePropertySetter = createFctPtr();
                if ((!nodePropertySetter.PointsToNull()) && ((node.IsValid()))) {
                    nodePropertySetter->SetNode(node);
                    propertySetter = nodePropertySetter;
                }
            }

            Animation::AnimationPropertySetter::SharedPointer AnimationPropertySetterFactoryCommon::CreateCorrespondingSetter(AnimationPropertySetterId propertyId, const Char* propertyName, const Vector<AnimatedPropertyChannels>& apcList, Candera::Internal::AssetId objectId, PropertySetterType setterType)
            {
                Int32 setterId = FindApsClassId(propertyId, apcList);
                return CreateAnimationPropertySetterByClassId(setterId, propertyName, objectId, setterType);
            }

            Int32 AnimationPropertySetterFactoryCommon::FindApsClassId(AnimationPropertySetterId propertyId, const Vector<AnimatedPropertyChannels> &apcList)
            {
                Int32 foundIndex = -1;
                for (Int i = 0; i < numMapperEntries; i++) {
                    if (propertyId == propertySettersMapper[i].propertyId) {
                        if ((static_cast<Int32>(apcList.Size()) == propertySettersMapper[i].channelCount) && (apcList.Size() == 1)) {
                            if (apcList[0] == propertySettersMapper[i].channel0Id) {
                                foundIndex = i;
                                break;
                            }
                        }
                        else if ((static_cast<Int32>(apcList.Size()) == propertySettersMapper[i].channelCount) && (apcList.Size() > 1)) {
                            foundIndex = i;
                            break;
                        }
                        else {
                            //do nothing
                        }
                    }
                }
                if (foundIndex == -1) {
                    return -1;
                }

                return propertySettersMapper[foundIndex].setterClassId;
            }

            Animation::AnimationPropertySetter::SharedPointer AnimationPropertySetterFactoryCommon::CreateAnimationPropertySetterByClassId(Int32 setterId, const Char* /*propertyName*/, AssetId objectId, PropertySetterType setterType)
            {
                Animation::AnimationPropertySetter::SharedPointer nullPtr(0);

                if (setterId == -1) {
                    return nullPtr;
                }

                if (m_assetProvider == 0) {
                    FEATSTD_LOG_ERROR("No AssetProvider associated to the AnimationPropertySetterFactory!");
                    return nullPtr;
                }
                AbstractNodePointer node;
                // TODO: Refactor later to an AbstractNodePointerByAssetId method (maybe better approach than try and error)
#ifdef CANDERA_2D_ENABLED
                Node2D* resultNode = m_assetProvider->GetNode2DByAssetId(objectId);
                node = AbstractNodePointer(resultNode);
#endif
#ifdef CANDERA_3D_ENABLED
                if (!node.IsValid()) {
                    Node* result = m_assetProvider->GetNodeByAssetId(objectId);
                    node = AbstractNodePointer(result);
                }
#endif
              //  AbstractNodePointer node = m_assetProvider->GetAbstractNodePointerByAssetId(objectId);
                if (!node.IsValid()) {
                    FEATSTD_LOG_ERROR("Could not find Node " AssetIdLogStr " to create animation property setter!", AssetIdLogArgs(objectId));
                    return nullPtr;
                }

                Animation::AnimationPropertySetter::SharedPointer propertySetter;

                switch (setterType) {
                    case pstAbsolute: {
                           for (Int i = 0; i < npsSize; ++i) {
                               if (abstractNodePropertySetters[i].setterId == setterId) {
                                   SetupAbstractNodePropertySetter(propertySetter, node, abstractNodePropertySetters[i].createFctPtr);
                                   break;
                               }
                           }

                           if (!propertySetter.PointsToNull()) {
                               return propertySetter;
                           }
                        break;
                    }

                    case pstRelative: {
                       break;
                    }
                    default:
                        break;
                }

                return nullPtr;
            }
        }
}
