//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ABSTRACTNODEPOINTERDATATYPE_H)
#define CANDERA_ABSTRACTNODEPOINTERDATATYPE_H

#include "AssetLoaderDataTypeTemplate.h"

#include <Candera/EngineBase/Common/AbstractNodePointer.h>
#include <Candera/System/MetaInfo/MetaInfoBase.h>

namespace Candera {

    namespace MetaInfo {
        namespace Internal {
            template<> struct DataType< Candera::AbstractNodePointer>
            {
                static inline bool ConvertToString(Candera::AbstractNodePointer const& ptr, Char *buf, UInt bufLen)
                {
#ifdef CANDERA_3D_ENABLED
                    if (ptr.ToNode() != 0) {
                        return Candera::MetaInfo::CanderaObjectConverterToString<Candera::Node*>::ConvertToString(ptr.ToNode(), buf, bufLen);
                    }
#endif
#ifdef CANDERA_2D_ENABLED
                    if (ptr.ToNode2D() != 0) {
                        return Candera::MetaInfo::CanderaObjectConverterToString<Candera::Node2D*>::ConvertToString(ptr.ToNode2D(), buf, bufLen);
                    }
#endif
                    return false;
                };

                static bool ConvertFromString(Candera::AbstractNodePointer &destination, const Char *buf, AssetProvider* provider = 0);

                static const Char* GetEditor();
            };
        }
    }
}

#endif // CANDERA_ASSETLOADERBASEDATATYPES_H
