//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if  !defined(CANDERA_SCENECONTEXT_H)
#define CANDERA_SCENECONTEXT_H

#include <CanderaAssetLoader/AssetLoaderBase/SceneContextBase.h>

namespace Candera {

    /** @addtogroup AssetLoader3D
     *  @{
     */

    // Forward declarations
    class Scene;
    namespace Internal {
        template <typename T>
        class AssetBuilderBase;
    }

    /**
    * @brief Encapsulates main objects that define a scene context an application can operate on.
    * These objects are:
    *  - The scene itself.
    *  - The list of widgets within the scene.
    *  - The list of attachments that can be Uploaded/Unloaded on host objects, like
    *      AnimationBlendedProperties on AnimationPlayers.
    */

    class SceneContext: public SceneContextBase {
    public:

        /**
        * Constructor
        * @param scene The associated Scene that is set.
        */
        SceneContext(Scene* scene);

        /**
        * Destructor
        */
        ~SceneContext();


        /**
        * Returns the associated scene.
        * @return The associated scene.
        */
        Scene* GetScene() { return m_scene; }

        using SceneContextBase::GetFirstWidget;
        using SceneContextBase::GetNextWidget;
        using SceneContextBase::GetWidget;
        
    private:
        friend class Internal::AssetBuilderBase<SceneContext*>;
        Scene* m_scene;

        SceneContext(): m_scene(0) {}
        void SetScene(Scene* scene) { m_scene = scene; }

    };

/** @} */ // end of AssetLoader3D

}

#endif //CANDERA_SCENECONTEXT_H
