//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSETLOADER3DDATATYPES_H)
#define CANDERA_ASSETLOADER3DDATATYPES_H

#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderBaseDataTypes.h>
#include <Candera/Engine3D/Core/3DStringBufferAppenders.h>

namespace Candera {
    class Group;
    class Mesh;
    class Light;
    class Camera;
    class Node;
    class Shader;

    namespace MetaInfo {
        namespace Internal {
            AssetLoaderDataTypeDef(Node*, "builtin://Node3DEditor")
            AssetLoaderDataTypeDef(FeatStd::MemoryManagement::SharedPointer<Shader>, "builtin://ShaderEditor")

            AssetLoaderDataTypeDef(Group*, "builtin://Group3DEditor")
            AssetLoaderDataTypeDef(Mesh*, "builtin://MeshEditor")
            AssetLoaderDataTypeDef(Light*, "builtin://LightEditor")
            AssetLoaderDataTypeDef(Camera*, "builtin://Camera3DEditor")
        }
    }
}

#endif // CANDERA_ASSETLOADER3DDATATYPES_H
