//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AssetLoader3DDataTypes.h"

#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/Engine3D/Core/Group.h>
#include <Candera/Engine3D/Core/Light.h>
#include <Candera/Engine3D/Core/Mesh.h>
#include <Candera/Engine3D/Core/Shader.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderDataTypeTemplate.h>

namespace Candera {
    namespace MetaInfo {
        namespace Internal {
            AssetLoaderDataTypeDecl(Node*, &AssetProvider::GetNodeByAssetId)
            AssetLoaderDataTypeDecl(FeatStd::MemoryManagement::SharedPointer<Shader>, &AssetProvider::GetShaderByAssetId)

            CanderaObjectInheritedDataTypeDecl(Group*, Node*)
            CanderaObjectInheritedDataTypeDecl(Mesh*, Node*)
            CanderaObjectInheritedDataTypeDecl(Light*, Node*)
            CanderaObjectInheritedDataTypeDecl(Camera*, Node*)
        }
    }
}

