//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TransformableAssetReader.h"
#include <Candera/Engine3D/Core/Transformable.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/Node3DCffReader.h>

namespace Candera {
    namespace Internal {

        using namespace Diagnostics;

        bool AssetReaderBase<Transformable>::ReadFirstPass(Transformable& transformable, LoaderContext& context)
        {
            Float x = 0.0F;
            Float y = 0.0F;
            Float z = 0.0F;
            CFFReader::GetNode3DPosition(context.handle, x, y, z);
            transformable.SetPosition(x, y, z);

            CFFReader::GetNode3DPivotPoint(context.handle, x, y, z);
            transformable.SetPivotPoint(Vector3(x, y, z));

            CFFReader::GetNode3DScale(context.handle, x, y, z);
            transformable.SetScale(Vector3(x, y, z));

            CFFReader::GetNode3DRotation(context.handle, x, y, z);
            transformable.SetRotation(Vector3(x, y, z));

            const Float* matrix = 0;
            if (CFFReader::GetOptionalNode3DTransform(context.handle, matrix)) {
                transformable.SetGenericTransform(Matrix4(matrix));
            }

            return true;
        }
    }
}
