//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_TEXTURE_BUILDER_H
#define CANDERA_TEXTURE_BUILDER_H

#include <Candera/Engine3D/Core/Texture.h>
#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/TransformableAssetReader.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Texture, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<Texture>: public GenericAssetReaderBase<Texture> {
        public:
            static bool ReadFirstPass(Texture& texture, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Texture> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Texture> > {
        public:
            static MemoryManagement::SharedPointer<Texture> Create(LoaderContext& context);
        };
    }
}
#endif // CANDERA_TEXTURE_BUILDER_H
