//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_STEREOCAMERA_BUILDER_H
#define CANDERA_STEREOCAMERA_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class StereoCamera;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::StereoCamera, CffLoaderType, Candera::Node);

        template<>
        class AssetBuilderBase<StereoCamera*>: public GenericAssetBuilderBase<StereoCamera*> {
        public:
            static StereoCamera* Create(LoaderContext& context);
        };

        template<>
        class AssetReaderBase<StereoCamera>: public GenericAssetReaderBase<StereoCamera> {
        public:
            static bool ReadFirstPass(StereoCamera& stereoscopicCamera, LoaderContext& context);
            static bool ReadSecondPass(StereoCamera& stereoscopicCamera, LoaderContext& context);
        };
    }
}

#endif // CANDERA_STEREOCAMERA_BUILDER_H
