//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SHAREDCLEARMODEASSETBUILDER_H)
#define CANDERA_SHAREDCLEARMODEASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>
#include <CanderaPlatform/Device/Common/Base/SharedClearMode.h>

namespace Candera {

    namespace Internal {

        AssetLoaderTypeInfo(SharedClearMode, CffLoaderType, void);

        template<>
        class AssetReaderBase<SharedClearMode>: public GenericAssetReaderBase<SharedClearMode> {
        public:
            static bool ReadFirstPass(SharedClearMode& sharedClearMode, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<SharedClearMode::SharedPointer>: public GenericAssetBuilderBase<SharedClearMode::SharedPointer> {
        public:
            static SharedClearMode::SharedPointer Create(LoaderContext& context);
            static void Dispose(SharedClearMode::SharedPointer sharedClearMode);
        };
    }
}

#endif  // CANDERA_SHAREDCLEARMODEASSETBUILDER_H
