//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "SharedClearModeAssetBuilder.h"

#include <CanderaAssetLoader/AssetLoaderBase/CffReader/ClearModeCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <Candera/Engine3D/Core/ClearMode.h>


namespace Candera {

    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

    namespace Internal {
        bool AssetReaderBase<SharedClearMode>::ReadFirstPass(SharedClearMode& sharedClearMode, LoaderContext& context)
        {
            ClearMode* clearMode = FEATSTD_NEW(ClearMode);
            if (clearMode == 0) {
                FEATSTD_LOG_ERROR("Failed to create ClearMode");
                return false;
            }

            Color clearColor;
            FEATSTD_LINT_CURRENT_SCOPE(864, "Violates MISRA C++ 2008 Required Rule 5-0-1: access does not depend on order")
            CFFReader::GetClearModeClearColor(context.handle, clearColor[0], clearColor[1], clearColor[2], clearColor[3]);
            clearMode->SetClearColor(clearColor);

            bool colorWriteEnabled[4];
            CFFReader::GetClearModeColorWriteEnabled(context.handle, colorWriteEnabled[0], colorWriteEnabled[1], colorWriteEnabled[2], colorWriteEnabled[3]);
            clearMode->SetColorWriteEnabled(colorWriteEnabled[0], colorWriteEnabled[1], colorWriteEnabled[2], colorWriteEnabled[3]);

            clearMode->SetDepthClearEnabled(CFFReader::GetClearModeIsDepthClearEnabled(context.handle));
            clearMode->SetClearDepth(CFFReader::GetClearModeClearDepth(context.handle));
            clearMode->SetStencilClearEnabled(CFFReader::GetClearModeIsStencilClearEnabled(context.handle));
            clearMode->SetStencilClearValue(CFFReader::GetClearModeStencilClearValue(context.handle));

            clearMode->SetStencilWriteMask(CFFReader::GetClearModeStencilWriteMask(context.handle));
            clearMode->SetSkyBoxEnabled(false); //for now skybox is disabled on shared clear modes
            
            sharedClearMode.SetClearMode(clearMode);

            return true;
        }

        SharedClearMode::SharedPointer AssetBuilderBase<SharedClearMode::SharedPointer>::Create(LoaderContext& /*context*/)
        {
            return SharedClearMode::Create();
        }

        void AssetBuilderBase<SharedClearMode::SharedPointer>::Dispose(SharedClearMode::SharedPointer sharedClearMode)
        {
            if (sharedClearMode != 0) {
                if (sharedClearMode->GetClearMode() != 0) {
                    FEATSTD_DELETE(sharedClearMode->GetClearMode());
                }
            }
        }
    }
}
