//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "RenderModeAssetBuilder.h"
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/RenderModeCffReader.h>

namespace Candera {

    using namespace MemoryManagement;

    namespace Internal {

        SharedPointer<RenderMode> AssetBuilderBase<SharedPointer<RenderMode> >::Create(LoaderContext& /*context*/)
        {
            return RenderMode::Create();
        }

        bool AssetReaderBase<RenderMode>::ReadFirstPass(RenderMode& renderMode, LoaderContext& context)
        {
            renderMode.SetInheritanceMask(CFFReader::GetRenderModeInheritanceBitmask(context.handle));
            renderMode.SetCulling(static_cast<RenderMode::Culling>(CFFReader::GetRenderModeCullMode(context.handle)));
            renderMode.SetWinding(static_cast<RenderMode::Winding>(CFFReader::GetRenderModeWindMode(context.handle)));
            bool colorWriteEnabled[4];
            CFFReader::GetRenderModeColorWriteEnabled(context.handle, colorWriteEnabled[0], colorWriteEnabled[1], colorWriteEnabled[2], colorWriteEnabled[3]);
            renderMode.SetColorWriteRedEnabled(colorWriteEnabled[0]);
            renderMode.SetColorWriteGreenEnabled(colorWriteEnabled[1]);
            renderMode.SetColorWriteBlueEnabled(colorWriteEnabled[2]);
            renderMode.SetColorWriteAlphaEnabled(colorWriteEnabled[3]);
            renderMode.SetDepthTestEnabled(CFFReader::GetRenderModeIsDepthTestEnabled(context.handle));
            renderMode.SetDepthWriteEnabled(CFFReader::GetRenderModeIsDepthWriteEnabled(context.handle));
            renderMode.SetDepthComparisonFunction(static_cast<RenderMode::ComparisonFunction>(CFFReader::GetRenderModeDepthComparisonFunction(context.handle)));
            renderMode.SetBlendingEnabled(CFFReader::GetRenderModeIsBlendingEnabled(context.handle));
            renderMode.SetDepthBias(CFFReader::GetRenderModeDepthBiasScaleFactor(context.handle),
                CFFReader::GetRenderModeDepthBiasUnits(context.handle));

            Float f1 = 0.0F;
            Float f2 = 0.0F;
            Float f3 = 0.0F;
            Float f4 = 0.0F;
            CFFReader::GetRenderModeBlendColor(context.handle, f1, f2, f3, f4);
            renderMode.SetBlendColor(Color(f1, f2, f3, f4));

            renderMode.SetBlendModeSeparate(static_cast<RenderMode::BlendFactor>(CFFReader::GetRenderModeSourceBlendFactorRGB(context.handle)),
                static_cast<RenderMode::BlendFactor>(CFFReader::GetRenderModeDestBlendFactorRGB(context.handle)),
                static_cast<RenderMode::BlendOperation>(CFFReader::GetRenderModeBlendOperationRGB(context.handle)),
                static_cast<RenderMode::BlendFactor>(CFFReader::GetRenderModeSourceBlendFactorAlpha(context.handle)),
                static_cast<RenderMode::BlendFactor>(CFFReader::GetRenderModeDestBlendFactorAlpha(context.handle)),
                static_cast<RenderMode::BlendOperation>(CFFReader::GetRenderModeBlendOperationAlpha(context.handle)));
            renderMode.SetStencilTestEnabled(CFFReader::GetRenderModeIsStencilTestEnabled(context.handle));

            RenderMode::StencilFunctionData stencilFunction;
            RenderMode::StencilOperationData stencilOperation;
            stencilFunction.compFunc = static_cast<RenderMode::ComparisonFunction>(CFFReader::GetRenderModeStencilFrontComparisonFunction(context.handle));
            stencilFunction.mask = CFFReader::GetRenderModeStencilFrontMask(context.handle);
            stencilFunction.refValue = CFFReader::GetRenderModeStencilFrontValue(context.handle);
            stencilOperation.depthFail = static_cast<RenderMode::StencilOperation>(CFFReader::GetRenderModeStencilFrontDepthFail(context.handle));
            stencilOperation.depthPass = static_cast<RenderMode::StencilOperation>(CFFReader::GetRenderModeStencilFrontDepthPass(context.handle));
            stencilOperation.stencilFail = static_cast<RenderMode::StencilOperation>(CFFReader::GetRenderModeStencilFrontStencilFail(context.handle));
            renderMode.SetStencilFunction(stencilFunction, RenderMode::FrontFace);
            renderMode.SetStencilOperation(stencilOperation, RenderMode::FrontFace);
            renderMode.SetStencilWriteMask(CFFReader::GetRenderModeStencilFrontWriteMask(context.handle), RenderMode::FrontFace);

            stencilFunction.compFunc = static_cast<RenderMode::ComparisonFunction>(CFFReader::GetRenderModeStencilBackComparisonFunction(context.handle));
            stencilFunction.mask = CFFReader::GetRenderModeStencilBackMask(context.handle);
            stencilFunction.refValue = CFFReader::GetRenderModeStencilBackValue(context.handle);
            stencilOperation.depthFail = static_cast<RenderMode::StencilOperation>(CFFReader::GetRenderModeStencilBackDepthFail(context.handle));
            stencilOperation.depthPass = static_cast<RenderMode::StencilOperation>(CFFReader::GetRenderModeStencilBackDepthPass(context.handle));
            stencilOperation.stencilFail = static_cast<RenderMode::StencilOperation>(CFFReader::GetRenderModeStencilBackStencilFail(context.handle));
            renderMode.SetStencilFunction(stencilFunction, RenderMode::BackFace);
            renderMode.SetStencilOperation(stencilOperation, RenderMode::BackFace);
            renderMode.SetStencilWriteMask(CFFReader::GetRenderModeStencilBackWriteMask(context.handle), RenderMode::BackFace);

            return true;
        }
    }
}
