//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ReflectionCameraAssetBuilder.h"
#include <Candera/Engine3D/Core/ReflectionCamera.h>
#include <Candera/Engine3D/Core/Scene.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/ReflectionCameraCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

namespace Candera {
    using namespace Diagnostics;

    namespace Internal {
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        ReflectionCamera* AssetBuilderBase<ReflectionCamera*>::Create(LoaderContext& /*context*/)
        {
            return ReflectionCamera::Create();
        }

        bool AssetReaderBase<ReflectionCamera>::ReadSecondPass(ReflectionCamera& reflectionCamera, LoaderContext& context)
        {
            Float x = 0.0F;
            Float y = 0.0F;
            Float z = 0.0F;
            CFFReader::GetReflectionCameraPlaneDirection(context.handle, x, y, z);
            reflectionCamera.SetReflectionPlane(Plane(Vector3(x, y, z),
                CFFReader::GetReflectionCameraPlaneDistance(context.handle)));

            const AssetId& sourceCameraAssetId = AssetIdFunctions::GetAssetId(CFFReader::GetReflectionCameraSourceCamera(context.handle));
            if (!sourceCameraAssetId.IsValid()) {
                FEATSTD_LOG_WARN("ReflectionCamera " AssetIdLogStr " has no source Camera attached", AssetIdLogArgs(context.id));
                return false;
            }
            Node* result = context.provider->GetNodeByAssetId(sourceCameraAssetId);
            Candera::Camera* sourceCamera = Dynamic_Cast<Camera*>(result);
            if (sourceCamera != 0) {
                reflectionCamera.SetSourceCamera(sourceCamera);
            }
            else {
                FEATSTD_LOG_ERROR("Failed to retrieve source Camera for ReflectionCamera " AssetIdLogStr, AssetIdLogArgs(context.id));
            }

            return true;
        }
    }
}
