//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ReferencedTemplateAssetBuilder.h"
#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <Candera/Engine3D/Core/Node.h>
#include <FeatStd/Diagnostics/Log.h>

namespace Candera {
    namespace Internal {
        FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

        ReferencedTemplate* AssetBuilderBase<ReferencedTemplate*>::Create(LoaderContext& context)
        {
            ReferencedTemplate* referencedTemplate = 0;
            Node* node = AssetBuilder<Node*>::CreateAndBuildFirstPass(context);
            if (node != 0) {
                if (!AssetBuilder<Node*>::BuildSecondPass(node, context)) {
                    FEATSTD_LOG_WARN("Failed to load Node for ReferencedTemplate " AssetIdLogStr, AssetIdLogArgs(context.id));
                }
                referencedTemplate = ASSETLOADER_TRANSIENT_NEW(ReferencedTemplate);
                if (referencedTemplate != 0) {
                    referencedTemplate->m_node = node;
                }
            }
            else {
                FEATSTD_LOG_ERROR("Failed to create Node from ReferencedTemplate " AssetIdLogStr, AssetIdLogArgs(context.id));
            }

            return referencedTemplate;
        }

        void AssetBuilderBase<ReferencedTemplate*>::Dispose(ReferencedTemplate* referencedTemplate)
        {
            if (referencedTemplate != 0) {
                if (referencedTemplate->m_node != 0) {
                    AssetBuilder<Node*>::Dispose(referencedTemplate->m_node);
                    referencedTemplate->m_node->Dispose();
                }
                ASSETLOADER_DELETE(referencedTemplate);
            }
        }
    }
}
