//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_POINTSPRITE_BUILDER_H
#define CANDERA_POINTSPRITE_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/GroupAssetBuilder.h>

namespace Candera {
    class PointSprite;
    namespace Internal {
        AssetLoaderTypeInfo(Candera::PointSprite, CffLoaderType, Candera::Node);

        template<>
        class AssetReaderBase<PointSprite>: public GenericAssetReaderBase<PointSprite> {
        public:
            static bool ReadFirstPass(PointSprite& pointSprite, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<PointSprite*>: public GenericAssetBuilderBase<PointSprite*> {
        public:
            static PointSprite* Create(LoaderContext& context);
        };
    }
}

#endif // CANDERA_POINTSPRITE_BUILDER_H


