//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PointSpriteAssetBuilder.h"
#include <Candera/Engine3D/Core/PointSprite.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/PointSpriteCffReader.h>

namespace Candera {

    using namespace Diagnostics;

    namespace Internal {

        PointSprite* AssetBuilderBase<PointSprite*>::Create(LoaderContext& /*context*/)
        {
            return PointSprite::Create();
        }

        bool AssetReaderBase<PointSprite>::ReadFirstPass(PointSprite& pointSprite, LoaderContext& context)
        {
            pointSprite.SetPointSize(CFFReader::GetPointSpritePointSize(context.handle));
            pointSprite.SetPointSizeScaleA(CFFReader::GetPointSpritePointSizeScaleA(context.handle));
            pointSprite.SetPointSizeScaleB(CFFReader::GetPointSpritePointSizeScaleB(context.handle));
            pointSprite.SetPointSizeScaleC(CFFReader::GetPointSpritePointSizeScaleC(context.handle));

            return true;
        }
    }
}
