//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_PLANARSHADOW_BUILDER_H
#define CANDERA_PLANARSHADOW_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/MeshAssetBuilder.h>

namespace Candera {
    class PlanarShadow;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::PlanarShadow, CffLoaderType, Candera::Mesh);

        template<>
        class AssetReaderBase<PlanarShadow>: public GenericAssetReaderBase<PlanarShadow> {
        public:
            static bool ReadFirstPass(PlanarShadow& planarShadow, LoaderContext& context);
            static bool ReadSecondPass(PlanarShadow& planarShadow, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<PlanarShadow*>: public GenericAssetBuilderBase<PlanarShadow*> {
        public:
            static PlanarShadow* Create(LoaderContext& context);
        };
    }
}

#endif // CANDERA_PLANARSHADOW_BUILDER_H
