//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PlanarShadowAssetBuilder.h"
#include <Candera/Engine3D/Core/Mesh.h>
#include <Candera/Engine3D/Core/Light.h>
#include <Candera/Engine3D/Core/PlanarShadow.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/PlanarShadowCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

namespace Candera {
    using namespace Diagnostics;

    namespace Internal {
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        PlanarShadow* AssetBuilderBase<PlanarShadow*>::Create(LoaderContext& /*context*/)
        {
            return PlanarShadow::Create();
        }

        bool AssetReaderBase<PlanarShadow>::ReadFirstPass(PlanarShadow& planarShadow, LoaderContext& context)
        {
            planarShadow.SetAutoVertexBufferEnabled(CFFReader::GetPlanarShadowIsAutoVertexBufferEnabled(context.handle));
            Float planeDirection[3];
            CFFReader::GetPlanarShadowPlaneDirection(context.handle, planeDirection[0], planeDirection[1], planeDirection[2]);

            planarShadow.SetPlane(Plane(Vector3(planeDirection[0], planeDirection[1], planeDirection[2]),
                CFFReader::GetPlanarShadowPlaneDistance(context.handle)));

            return true;
        }

        bool AssetReaderBase<PlanarShadow>::ReadSecondPass(PlanarShadow& planarShadow, LoaderContext& context)
        {
            const AssetId& lightAssetId = AssetIdFunctions::GetAssetId(CFFReader::GetPlanarShadowLight(context.handle));
            if (!lightAssetId.IsValid()) {
                FEATSTD_LOG_WARN("PlanarShadow " AssetIdLogStr " has no Light attahced!", AssetIdLogArgs(context.id));
                return false;
            }
            Node* result = context.provider->GetNodeByAssetId(lightAssetId);
            if (result == 0){
                FEATSTD_LOG_DEBUG("Light node not found.");
            }
            Light* light = Dynamic_Cast<Light*>(result);
            planarShadow.SetLight(light);

            if (light == 0) {
                FEATSTD_LOG_WARN("Failed to associate Light " AssetIdLogStr " to PlanarShadow "
                    AssetIdLogStr, AssetIdLogArgs(lightAssetId), AssetIdLogArgs(context.id));
            }

            const AssetId& alignmentNodeId = AssetIdFunctions::GetAssetId(CFFReader::GetPlanarShadowAlignmentNode(context.handle));
            if (alignmentNodeId.IsValid()) {
                Node* alignmentNode = context.provider->GetNodeByAssetId(alignmentNodeId);
                if (alignmentNode == 0) {
                    FEATSTD_LOG_WARN("Failed to associate alignment Node " AssetIdLogStr " to PlanarShadow "
                        AssetIdLogStr, AssetIdLogArgs(alignmentNodeId), AssetIdLogArgs(context.id));
                }

                planarShadow.SetAlignmentNode(alignmentNode);
            } //else situation is valid, there is no alignemnet node

            return true;
        }
    }
}
