//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NODE_BUILDER_H)
#define CANDERA_NODE_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/TransformableAssetReader.h>

namespace Candera {
    namespace DynamicProperties {
        class PropertyHierarchyNode;
        class DynamicPropertyHost;
    }
    class Node;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Node, CffLoaderType, Candera::Transformable);

        class NodeChildrenReader {
        public:
            bool ReadFirstPass(Node& node, CffLoaderContext& context) const;
            bool ReadSecondPass(Node& node, CffLoaderContext& context) const;
        protected:
            virtual Int32 GetChildrenCount(CffLoaderContext& context) const = 0;
            virtual AssetDataHandle GetChildDataHandle(CffLoaderContext& context, Int32 index) const = 0;
        };

        template<>
        class AssetReaderBase<Node>: public GenericAssetReaderBase<Node> {
        public:
            static bool ReadFirstPass(Node& node, LoaderContext& context);
            static bool ReadSecondPass(Node& node, LoaderContext& context);
        private:
            static bool ReadDynamicProperty(const DynamicProperties::PropertyHierarchyNode& phn, DynamicProperties::DynamicPropertyHost& host, LoaderContext& context);
        };

        template <>
        class AssetBuilder<Node*>: public GenericAssetBuilderBase<Node*> {
        public:
            static Node* CreateAndBuildFirstPass(LoaderContext& context);
            static bool BuildSecondPass(Node* node, LoaderContext& context);
            static void Dispose(Node* node);
        };
    }
}

#endif  // CANDERA_NODE_BUILDER_H
