//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_MORPHINGMESH_BUILDER_H
#define CANDERA_MORPHINGMESH_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class MorphingMesh;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::MorphingMesh, CffLoaderType, Candera::Node);

        template<>
        class AssetReaderBase<MorphingMesh>: public GenericAssetReaderBase<MorphingMesh> {
        public:
            static bool ReadFirstPass(MorphingMesh& morphingMesh, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MorphingMesh*>: public GenericAssetBuilderBase<MorphingMesh*> {
        public:
            static MorphingMesh* Create(LoaderContext& context);
        };
    }
}
#endif // CANDERA_MORPHINGMESH_BUILDER_H
