//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MeshAssetBuilder.h"
#include <Candera/Engine3D/Core/Mesh.h>
#include <Candera/System/Diagnostics/Log.h>

#include <Candera/Engine3D/Core/Mesh.h>
#include <Candera/Engine3D/Core/PlanarShadow.h>

#include <CanderaAssetLoader/AssetLoaderBase/CffReader/MeshCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProviderInternal.h>

namespace Candera {
    namespace Internal {
        using namespace Diagnostics;
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        Mesh* AssetBuilderBase<Mesh*>::Create(LoaderContext& /*context*/)
        {
            return Mesh::Create();
        }

        bool AssetReaderBase<Mesh>::ReadFirstPass(Mesh& mesh, LoaderContext& context)
        {
            AssetId vbId = AssetIdFunctions::GetAssetId(CFFReader::GetMeshVertexBuffer(context.handle));
            if (!vbId.IsValid()) {
                FEATSTD_LOG_INFO("Mesh " AssetIdLogStr " has no VertexBuffer attached!", AssetIdLogArgs(context.id));
            }
            else {
                if ((!CreateDependency(context, mesh, vbId, SetVertexBuffer))) {
                    FEATSTD_LOG_WARN("Failed to associate VertexBuffer " AssetIdLogStr " to Mesh "
                        AssetIdLogStr, AssetIdLogArgs(vbId), AssetIdLogArgs(context.id));
                }
            }

            return true;
        }

        bool AssetReaderBase<Mesh>::SetVertexBuffer(Mesh& mesh, AssetId id, DependencyList* dependencyList, const DefaultAssetProvider* provider)
        {
            MemoryManagement::SharedPointer<VertexBuffer> vb = provider->m_internal->m_vertexBufferProvider.Get(id, dependencyList);

            if (vb != 0) {
                mesh.SetVertexBuffer(vb);
            }

            for (Node* child = mesh.GetFirstChild(); child != 0; child = child->GetNextSibling()) {
                PlanarShadow* planarShadow = Dynamic_Cast<PlanarShadow*>(child);
                if (planarShadow != 0) {
                    planarShadow->SetVertexBuffer(vb);
                }
            }

            return (vb != 0);
        }
    }
}
