//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_MATERIALBUILDER_H
#define CANDERA_MATERIALBUILDER_H

#include <Candera/Engine3D/Core/Material.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {
        AssetLoaderTypeInfo(Candera::Material, CffLoaderType, CanderaObject);

        template<>
        class AssetReaderBase<Material>: public GenericAssetReaderBase<Material> {
        public:
            static bool ReadFirstPass(Material& material, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Material> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Material> > {
        public:
            static MemoryManagement::SharedPointer<Material> Create(LoaderContext& context);
        };
    }
}

#endif // CANDERA_MATERIALBUILDER_H
