//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MaterialAssetBuilder.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/MaterialCffReader.h>

namespace Candera {

    using namespace Diagnostics;
    using namespace MemoryManagement;

    namespace Internal {

        SharedPointer<Material> AssetBuilderBase<SharedPointer<Material> >::Create(LoaderContext& /*context*/)
        {
            return Material::Create();
        }

        bool AssetReaderBase<Material>::ReadFirstPass(Material& material, LoaderContext& context)
        {
            Float red = 0.0F;
            Float green = 0.0F;
            Float blue = 0.0F;
            Float alpha = 0.0F;

            CFFReader::GetMaterialAmbient(context.handle, red, green, blue, alpha);
            material.SetAmbient(Color(red, green, blue, alpha));

            CFFReader::GetMaterialDiffuse(context.handle, red, green, blue, alpha);
            material.SetDiffuse(Color(red, green, blue, alpha));

            CFFReader::GetMaterialEmissive(context.handle, red, green, blue, alpha);
            material.SetEmissive(Color(red, green, blue, alpha));

            CFFReader::GetMaterialSpecular(context.handle, red, green, blue, alpha);
            material.SetSpecular(Color(red, green, blue, alpha));

            material.SetSpecularPower(CFFReader::GetMaterialPower(context.handle));

            return true;
        }
    }
}
