//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_LIGHT_BUILDER_H
#define CANDERA_LIGHT_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class Light;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Light, CffLoaderType, Candera::Node);

        template<>
        class AssetReaderBase<Light>: public GenericAssetReaderBase<Light> {
        public:
            static bool ReadFirstPass(Light& light, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Light*>: public GenericAssetBuilderBase<Light*> {
        public:
            static Light* Create(LoaderContext& context);
        };
    }
}
#endif // CANDERA_LIGHT_BUILDER_H
