//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GroupAssetBuilder.h"
#include <Candera/Engine3D/Core/Group.h>
#if defined(CANDERA_LAYOUT_ENABLED)
#include <Candera/EngineBase/Layout/Layout.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/LayouterAssetBuilder.h>
#endif
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/GroupCffReader.h>

namespace Candera {

    using namespace Diagnostics;

    namespace Internal {

        bool AssetReaderBase<Group>::ReadFirstPass(Group& group, LoaderContext& context)
        {
            /* This code is valid only when we fully support 3D (not only canvas)
            if (CFFReader::GetGroupIsLayoutEnabled(context.handle)) {
#if defined(CANDERA_LAYOUT_ENABLED)
                const AssetDataHandle& dataHandle = CFFReader::GetGroup2DLayout(context.handle);
                LoaderContext layouterContext = context.Clone(dataHandle);
                group.SetLayouter(AssetBuilder<Candera::Layouter*>::CreateAndBuildFirstPass(layouterContext));
#else
                FEATSTD_UNUSED2(group, context);
#endif
            }*/
            
            FEATSTD_UNUSED2(group, context);
            return true;
        }

        bool AssetReaderBase<Group>::ReadSecondPass(Group& group, LoaderContext& context)
        {
            /* This code is valid only when we fully support 3D (not only canvas)
#if defined(CANDERA_LAYOUT_ENABLED)
            if (CFFReader::GetGroupIsLayoutEnabled(context.handle)) {
                const AssetDataHandle& layoutHandle = CFFReader::GetGroupLayout(context.handle);
                LoaderContext layouterContext = context.Clone(layoutHandle);
                return AssetBuilder<Layouter*>::BuildSecondPass(group.GetLayouter(), layouterContext);
            }
#else
            FEATSTD_UNUSED2(group, context);
#endif
            */
            FEATSTD_UNUSED2(group, context);
            return true;
        }

        Group* AssetBuilderBase<Group*>::Create(LoaderContext& /*context*/)
        {
            return Group::Create();
        }

        void AssetBuilderBase<Group*>::Dispose(const Group* group)
        {
            /*
#if defined(CANDERA_LAYOUT_ENABLED)
            if (group != 0) {
                Layouter* layouter = group->GetLayouter();
                if (layouter != DefaultLayouter::GetInstance()) {
                    AssetBuilder<Layouter*>::Dispose(layouter);
                }
            }
#else
            FEATSTD_UNUSED(group);
#endif
            */
            FEATSTD_UNUSED(group);
        }
    }
}
