//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_COMPOSITEGROUP_BUILDER_H)
#define CANDERA_COMPOSITEGROUP_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/GroupAssetBuilder.h>
#include <Candera/EngineBase/DynamicProperties/DynamicProperty.h>
#include <CanderaWidget/WidgetBase/WidgetBase.h>

namespace Candera {
    class CompositeGroup;
    namespace Internal {
        AssetLoaderTypeInfo(Candera::CompositeGroup, CffLoaderType, Candera::Group);

        template<>
        class AssetBuilderBase<CompositeGroup*>: public GenericAssetBuilderBase<CompositeGroup*> {
        public:
            static CompositeGroup* Create(const LoaderContext& context);
            static void Dispose(const CompositeGroup* compositeGroup);
        };

        template<>
        class AssetReaderBase<CompositeGroup>: public GenericAssetReaderBase<CompositeGroup> {
        public:
            static bool ReadSecondPass(CompositeGroup& compositeGroup, const LoaderContext& context);
        };

        class CompositeInstanceBuilder {
        public:
            static bool IsValid(CompositeGroup*, CffLoaderContext) { return true; }
            static CompositeGroup* CreateAndBuildFirstPass(CffLoaderContext context);
            static bool BuildSecondPass(CompositeGroup* compositeGroup, CffLoaderContext context);
            static void Dispose(CompositeGroup* compositeInstance);
        };

        class CompositePropertyList {
        public:
            struct Property {
                const Char* name;
                const Char* property;
                WidgetBase* widget;
                MetaInfo::PropertyMetaInfo<WidgetBase>* metaInfo;
            };

            static CompositePropertyList& DefaultPropertyList();
            static const CompositePropertyList& GetPropertyList(const CompositeGroup* compositeGroup);
            static bool SetPropertyList(CompositeGroup* compositeGroup, const CompositePropertyList& propertyList);
            static bool ClearPropertyList(CompositeGroup* compositeGroup);
            const Property* GetProperty(const Char* name) const;
            
            Vector<Property> m_list;

            bool operator==(const CompositePropertyList& other) const;

        private:
            CdaDynamicProperties(CompositeGroup, DynamicProperties::DynamicPropertyHost);
            CdaDynamicPropertyUnregistered(PropertyList, CompositePropertyList);
            CdaDynamicPropertyDefaultValue(DefaultPropertyList());
            CdaDynamicPropertyEnd();
            CdaDynamicPropertiesEnd();
        };
    }
}

#endif  // CANDERA_COMPOSITEGROUP_BUILDER_H
