//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CANVASSPRITE_BUILDER_H)
#define CANDERA_CANVASSPRITE_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/CanvasRenderableAssetReader.h>

namespace Candera {
    class CanvasSprite;
    namespace Internal {
        AssetLoaderTypeInfo(CanvasSprite, CffLoaderType, CanvasRenderable);

        template<>
        class AssetBuilderBase<CanvasSprite*> : public GenericAssetBuilderBase<CanvasSprite*>{
        public:
            static CanvasSprite* Create(LoaderContext& context);
        };

        inline CanvasSprite* AssetBuilderBase<CanvasSprite*>::Create(LoaderContext& context)
        {
            FEATSTD_UNUSED(context);
            return CanvasSprite::Create();
        }
    }
}


#endif  // CANDERA_CANVASSPRITE_BUILDER_H
