//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CANVASGROUP_BUILDER_H)
#define CANDERA_CANVASGROUP_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/GroupAssetBuilder.h>

namespace Candera {
    class CanvasGroup;
    namespace Internal {
        AssetLoaderTypeInfo(CanvasGroup, CffLoaderType, Group);

        template<>
        class AssetReaderBase<CanvasGroup> : public GenericAssetReaderBase<CanvasGroup>{
        public:
            static bool ReadFirstPass(CanvasGroup& group, LoaderContext& context);
            static bool ReadSecondPass(CanvasGroup& group, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<CanvasGroup*> : public GenericAssetBuilderBase<CanvasGroup*>{
        public:
            static CanvasGroup* Create(LoaderContext& context);
            static void Dispose(const CanvasGroup* group);
        };
    }
}


#endif  // CANDERA_CANVASGROUP_BUILDER_H
