//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CanvasGroupAssetBuilder.h"

#include <Candera/Engine3D/Canvas/CanvasGroup.h>
#if defined(CANDERA_LAYOUT_ENABLED)
#include <Candera/EngineBase/Layout/Layout.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/LayouterAssetBuilder.h>
#endif
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/CanvasGroupCffReader.h>

namespace Candera {
    namespace Internal {


        bool AssetReaderBase<CanvasGroup>::ReadFirstPass(CanvasGroup& group, LoaderContext& context)
        {
            if (CFFReader::GetCanvasGroupIsLayoutEnabled(context.handle)) {
#if defined(CANDERA_LAYOUT_ENABLED)
                const AssetDataHandle& dataHandle = CFFReader::GetCanvasGroupLayout(context.handle);
                LoaderContext layouterContext = context.Clone(dataHandle);
                group.SetLayouter(AssetBuilder<Candera::Layouter*>::CreateAndBuildFirstPass(layouterContext));
#else
                FEATSTD_UNUSED2(group, context);
#endif
            }
            return true;
        }

        bool AssetReaderBase<CanvasGroup>::ReadSecondPass(CanvasGroup& group, LoaderContext& context)
        {
#if defined(CANDERA_LAYOUT_ENABLED)
            if (CFFReader::GetCanvasGroupIsLayoutEnabled(context.handle)) {
                const AssetDataHandle& layoutHandle = CFFReader::GetCanvasGroupLayout(context.handle);
                LoaderContext layouterContext = context.Clone(layoutHandle);
                return AssetBuilder<Layouter*>::BuildSecondPass(group.GetLayouter(), layouterContext);
            }
#else
            FEATSTD_UNUSED2(group, context);
#endif
            return true;
        }

        Candera::CanvasGroup* AssetBuilderBase<CanvasGroup*>::Create(LoaderContext& context)
        {
            FEATSTD_UNUSED(context);
            return CanvasGroup::Create();
        }

        void AssetBuilderBase<CanvasGroup*>::Dispose(const CanvasGroup* group)
        {
#if defined(CANDERA_LAYOUT_ENABLED)
            if (group != 0) {
                Layouter* layouter = group->GetLayouter();
                if (layouter != DefaultLayouter::GetInstance()) {
                    AssetBuilder<Layouter*>::Dispose(layouter);
                }
            }
#else
            FEATSTD_UNUSED(group);
#endif
        }

    }
}
