//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CANVAS_BUILDER_H)
#define CANDERA_CANVAS_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/CanvasGroupAssetBuilder.h>

namespace Candera {
    class Canvas;
    namespace Internal {
        AssetLoaderTypeInfo(Canvas, CffLoaderType, CanvasGroup);

        template<>
        class AssetBuilderBase<Canvas*> : public GenericAssetBuilderBase<Canvas*>{
        public:
            static Canvas* Create(LoaderContext& context);
        };

        inline Canvas* AssetBuilderBase<Canvas*>::Create(LoaderContext& context)
        {
            FEATSTD_UNUSED(context);
            return Canvas::Create();
        }
    }
}


#endif  // CANDERA_CANVAS_BUILDER_H
