//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CAMERA_BUILDER_H)
#define CANDERA_CAMERA_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class Camera;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Camera, CffLoaderType, Candera::Node);

        template<>
        class AssetReaderBase<Camera>: public GenericAssetReaderBase<Camera> {
        public:
            static bool ReadFirstPass(Camera& camera, LoaderContext& context);
            static bool ReadSecondPass(Camera& camera, LoaderContext& context);

        private:
            enum CameraProjectionType {
                Perspective = 0,    ///< Perspective projection.
                Orthographic,       ///< Orthographic projection.
                Generic             ///< Generic projection.
            };

            enum CameraRenderStrategyType {
                None        = 0,    ///< No render strategy.
                Benchmark   = 1,    ///< Benchmark render strategy, rendering is paused once a specified benchmark value is reached. 
                OcclusionCulling = 2///< Oclusion culling
            };
        };

        template<>
        class AssetBuilderBase<Camera*>: public GenericAssetBuilderBase<Camera*> {
        public:
            static Camera* Create(LoaderContext& context);
            static void Dispose(const Camera* camera);
        };
    }
}

#endif  // CANDERA_CAMERA_BUILDER_H
