//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BitmapTextureImageAssetBuilder.h"
#include <FeatStd/Util/StaticObject.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProviderInternal.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/BitmapCffReader.h>

namespace Candera {
    using namespace MemoryManagement;

    namespace Internal {
        FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

        bool AssetReaderBase<BitmapTextureImage>::ReadFirstPass(BitmapTextureImage& bitmapTextureImage, LoaderContext& context)
        {
            bitmapTextureImage.SetTextureMemoryPool(static_cast<TextureImage::TextureMemoryPool>(CFFReader::GetBitmapMemoryPool(context.handle)));

            if (!CreateDependency(context, bitmapTextureImage, context.id, SetBitmap)) {
                FEATSTD_LOG_WARN("Failed associate Bitmap to BitmapImage2D %s", bitmapTextureImage.GetName());
            }

            if (!bitmapTextureImage.SetMipMappingEnabled(CFFReader::GetBitmapIsMipMappingEnabled(context.handle))) {
                FEATSTD_LOG_WARN("Set MipMapping-Enabled failed for BitmapTextureImage %s", bitmapTextureImage.GetName());
            }
            return true;
        }

        bool AssetReaderBase<BitmapTextureImage>::SetBitmap(BitmapTextureImage& bitmapTextureImage, AssetId id, DependencyList* dependencyList, const DefaultAssetProvider* provider)
        {
            Bitmap::SharedPointer bitmap = provider->m_internal->m_bitmapProvider.Get(id, dependencyList);

            if (!bitmapTextureImage.SetBitmap(bitmap)) {
                FEATSTD_LOG_WARN("Set Bitmap failed for BitmapTextureImage %s", bitmapTextureImage.GetName());
            }

            return (bitmap != 0);
        }

        SharedPointer<BitmapTextureImage> AssetBuilderBase<SharedPointer<BitmapTextureImage> >::Create(LoaderContext& /*context*/)
        {
            return BitmapTextureImage::Create();
        }
    }
}
