//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BillboardAssetBuilder.h"
#include <Candera/Engine3D/Core/Billboard.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/BillboardCffReader.h>

namespace Candera {

    using namespace Diagnostics;
        namespace Internal {

        bool AssetReaderBase<Candera::Billboard>::ReadFirstPass(Billboard& billboard, LoaderContext& context)
        {
            billboard.SetAlignment(static_cast<Candera::Billboard::Alignment>(CFFReader::GetBillboardAlignment(context.handle)));

            Float u = 0.0F;
            Float v = 0.0F;

            CFFReader::GetBillboardBottomLeft(context.handle, u, v);
            billboard.SetTextureCoordinateBottomLeft(u, v);

            CFFReader::GetBillboardBottomRight(context.handle, u, v);
            billboard.SetTextureCoordinateBottomRight(u, v);

            CFFReader::GetBillboardTopLeft(context.handle, u, v);
            billboard.SetTextureCoordinateTopLeft(u, v);

            CFFReader::GetBillboardTopRight(context.handle, u, v);
            billboard.SetTextureCoordinateTopRight(u, v);

            return billboard.ComputeBoundingSphere();
        }

        Billboard* AssetBuilderBase<Candera::Billboard*>::Create(LoaderContext& context)
        {
            return Billboard::Create(CFFReader::GetBillboardWidth(context.handle), CFFReader::GetBillboardHeight(context.handle));
        }
    }
}
