//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AppearanceCollectionAssetBuilder.h"
#include <Candera/Engine3D/Core/MultiPassAppearance.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/AppearanceCollectionCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/AppearanceAssetBuilder.h>

namespace Candera {

    using namespace Diagnostics;
    using namespace MemoryManagement;

    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

    namespace Internal {
        SharedPointer<Appearance> AppearanceCollectionAssetBuilder::CreateAndBuildFirstPass(CffLoaderContext& context)
        {
            Int32 appearanceCount = CFFReader::GetAppearanceCollectionChildrenAttachmentCount(context.handle);
            if (appearanceCount == 0) {
                return SharedPointer<Appearance>(0);
            }

            const bool isMultiPass = (appearanceCount > 1);
            SharedPointer<Appearance> baseAppearance;
            SharedPointer<MultiPassAppearance> currentAppearanceMP;

            for (Int index = 0; index < appearanceCount; ++index) {
                SharedAttachmentType attachmentType = static_cast<SharedAttachmentType>(CFFReader::GetAppearanceCollectionChildrenAttachmentTypeOfElementAt(context.handle, index));
                if (attachmentType == NotSharedAttachment) {
                    const AssetDataHandle& appearanceHandle = CFFReader::GetAppearanceCollectionChildrenAttachmentElementAt(context.handle, index);
                    CffLoaderContext appearanceContext = context.Clone(appearanceHandle);
                    SharedPointer<Appearance> newAppearance;
                    SharedPointer<MultiPassAppearance> newAppearanceMP;
                    if (isMultiPass) {
                        newAppearanceMP = AssetBuilder<SharedPointer<MultiPassAppearance> >::CreateInOnePass(appearanceContext);
                        newAppearance = newAppearanceMP;
                    }
                    else {
                        newAppearance = AssetBuilder<SharedPointer<Appearance> >::CreateInOnePass(appearanceContext);
                    }

                    if (baseAppearance == 0) {
                        baseAppearance = newAppearance;
                    }
                    if (currentAppearanceMP != 0) {
                        currentAppearanceMP->SetNextPass(newAppearanceMP);
                    }
                    currentAppearanceMP = newAppearanceMP;
                }

                if (attachmentType == SharedAttachment) {
                    if (!isMultiPass) {
                        Candera::Internal::AssetId result = AssetIdFunctions::GetAssetId(CFFReader::GetAppearanceCollectionChildrenAttachmentIdOfElementAt(context.handle, index));
                        if (!result.IsValid()) {
                            FEATSTD_LOG_DEBUG("SharedAttachment: AssetId is not valid");
                        }
                        baseAppearance = context.provider->GetAppearanceByAssetId(result);
                        if (baseAppearance.PointsToNull()){
                            FEATSTD_LOG_DEBUG("Requested appearance does not exist!");
                        }
                    }
                }
            }
            
            return baseAppearance;
        }
    }
}

