//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AssetLoader2DDataTypes.h"

#include <Candera/Engine2D/Core/ProxyImage2D.h>
#include <Candera/Engine2D/Core/BitmapImage2D.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>
#include <CanderaAssetLoader/AssetLoaderBase/ContentLoader.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderDataTypeTemplate.h>

#include <Candera/Engine2D/Core/Camera2D.h>
#include <Candera/Engine2D/Core/RenderNode.h>
#include <Candera/Engine2D/Core/Group2D.h>

namespace Candera {
    using namespace Internal;
    using namespace MemoryManagement;


    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

    namespace MetaInfo {
        namespace Internal {
            AssetLoaderDataTypeDecl(Node2D*, &AssetProvider::GetNode2DByAssetId)
            CanderaObjectInheritedDataTypeDecl(Camera2D*, Node2D*)
            CanderaObjectInheritedDataTypeDecl(RenderNode*, Node2D*)
            CanderaObjectInheritedDataTypeDecl(Group2D*, Node2D*)

            bool DataType<SharedPointer<Image2D> >::ConvertFromString(SharedPointer<Image2D> &image2D, const Char *buf, AssetProvider* assetProvider /*= 0*/ )
            {
                image2D.Release();

                UInt32 tab[4] = {0};
                if (SerializationPlatform::ToBinary<UInt32*>(buf, ",", &tab[0], &tab[4]) != 4) {
                    FEATSTD_LOG_ERROR("Failed to deserialize AssetId");
                    return false;
                }
                AssetId objectId = AssetIdFunctions::GetAssetId(tab);
                if (!objectId.IsValid()) {
                    FEATSTD_LOG_INFO("No object to convert.");
                    return false;
                }

                if (assetProvider == 0) {
                    assetProvider = ContentLoader::GetInstance().GetAssetProvider();
                    if (assetProvider == 0) {
                        FEATSTD_LOG_ERROR("No associated AssetProvider to obtain Image " AssetIdLogStr, AssetIdLogArgs(objectId));
                        return false;
                    }
                }

                image2D = assetProvider->GetBitmapImage2DByAssetId(objectId);
                if (image2D == 0) {
                    GraphicDeviceUnit* gdu = assetProvider->GetGraphicDeviceUnitByAssetId(objectId);
                    if (gdu != 0) {
                        SharedPointer<ProxyImage2D> proxyImage2D = ProxyImage2D::Create();
                        if (proxyImage2D != 0) {
                            proxyImage2D->SetImageSource(gdu->ToImageSource2D());
                            image2D = proxyImage2D;
                        }
                        else {
                            FEATSTD_LOG_ERROR("No ProxyImage created");
                        }
                    }
                    else {
                        FEATSTD_LOG_ERROR("Image2d " AssetIdLogStr " not found!", AssetIdLogArgs(objectId));
                    }
                }

                return (image2D != 0);
            }
        }

    }
}

