//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SCENE2DCONTEXTASSETBUILDER_H)
#define CANDERA_SCENE2DCONTEXTASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/SceneContextBaseAssetReader.h>

namespace Candera {
    class Scene2DContext;

    namespace Internal {

        AssetLoaderTypeInfo(Scene2DContext, CffLoaderType, SceneContextBase);

        template<>
        class AssetReaderBase<Scene2DContext>: public GenericAssetReaderBase<Scene2DContext> {
        public:
            static bool ReadSecondPass(Scene2DContext& sceneContext, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Scene2DContext*> : public GenericAssetBuilderBase<Candera::Scene2DContext*> {
        public:
            static Candera::Scene2DContext* Create(LoaderContext& context);
            static void Dispose(Scene2DContext* sceneContext);
            static bool IsValid(const Scene2DContext* sceneContext, LoaderContext& context);
        };

        typedef AssetBuilderBase<Scene2DContext*> Scene2DContextAssetBuilder;
    }
}

#endif  // CANDERA_SCENE2DCONTEXTASSETBUILDER_H
