//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Scene2DAssetBuilder.h"
#include <Candera/Engine2D/Core/Scene2D.h>

#include <CanderaAssetLoader/AssetLoaderBase/CffReader/SceneCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

namespace Candera {
    using namespace Diagnostics;

    namespace Internal {

        class Scene2DNode2DChildrenReader: public Node2DChildrenReader {
        protected:
            virtual Int32 GetChildrenCount(CffLoaderContext& context) const
            { return CFFReader::GetSceneChildrenCount(context.handle); }

            virtual AssetDataHandle GetChildDataHandle(CffLoaderContext& context, Int32 index) const
            { return CFFReader::GetSceneChildrenElementAt(context.handle, index); }
        };

        Scene2D* AssetBuilderBase<Scene2D*>::Create(LoaderContext& /*context*/)
        {
            return Scene2D::Create();
        }

        bool AssetReaderBase<Scene2D>::ReadFirstPass(Scene2D& scene, LoaderContext& context)
        {
            //disable rendering of any camera until the whole scene tree is constructed.
            scene.SetRenderingEnabled(false);
            return Scene2DNode2DChildrenReader().ReadFirstPass(scene, context);
        }

        bool AssetReaderBase<Scene2D>::ReadSecondPass(Scene2D& scene, LoaderContext& context)
        {
            //reenable rendering of cameras since whole scene tree is constructed.
            scene.SetRenderingEnabled(true);
            return Scene2DNode2DChildrenReader().ReadSecondPass(scene, context);
        }

        Int32 SceneNode2DChildrenReader::GetChildrenCount(CffLoaderContext& context) const
        {
            return CFFReader::GetSceneChildrenCount(context.handle);
        }

        AssetDataHandle SceneNode2DChildrenReader::GetChildDataHandle(CffLoaderContext& context, Int32 index) const
        {
            return CFFReader::GetSceneChildrenElementAt(context.handle, index);
        }

    }
}
