//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GROUP2D_BUILDER_H)
#define CANDERA_GROUP2D_BUILDER_H

#include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/Node2DAssetBuilder.h>

namespace Candera {
    class Group2D;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Group2D, CffLoaderType, Candera::Node2D);

        template<>
        class AssetReaderBase<Group2D>: public GenericAssetReaderBase<Group2D> {
        public:
            static bool ReadFirstPass(Group2D& group, LoaderContext& context);
            static bool ReadSecondPass(Group2D& group, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Group2D*>: public GenericAssetBuilderBase<Group2D*> {
        public:
            static Group2D* Create(LoaderContext& context);
            static void Dispose(const Group2D* group);
        };
        
        typedef AssetBuilderBase<Group2D*> Group2DAssetBuilder;
    }
}

#endif  // CANDERA_GROUP2D_BUILDER_H
