//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_EFFECT2D_BUILDER_H)
#define CANDERA_EFFECT2D_BUILDER_H

#include <Candera/Engine2D/Effects/Effect2D.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {
        AssetLoaderTypeInfo(Candera::Effect2D, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<Effect2D>: public GenericAssetReaderBase<Effect2D> {
        public:
            static bool ReadSecondPass(Effect2D& effect, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Effect2D> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Effect2D> > {
        public:
            static MemoryManagement::SharedPointer<Effect2D> Create(LoaderContext& context);
        };
    }
}


#endif  // CANDERA_EFFECT2D_BUILDER_H
